/******************************************************************************
 * %Id: gfx_bridge_data.h,v 1.5 2009/01/19 05:01:00 furuta Exp $
 *
 * FileName		:gfx_bridge_data.h
 *
 * Description	:Definition header of data used in bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_GFX_BRIDGE_DATA_H_
#define	_GFX_BRIDGE_DATA_H_

#include <linux/iosc/iosc-devices.h>

#define GFX_MAX_FD_NAME         256
#define GFX_MAX_COLOR_PALETTE   256
#define GFX_IOSC_SEND_BUF_SIZE  0x1000
#define GFX_CANVAS_INFO_MAX_NUM 3
#define GFX_MAX_COORDINATES     4096
#define GFX_MIN_COORDINATES     (-4096)
#define GFX_MAX_DIMENSIONS      2048
#define GFX_MIN_DIMENSIONS      0

/* Canvas ID */
typedef unsigned long   gfx_canvas_id_t;

/* YUV entry */
typedef struct {
  unsigned char       a;
  unsigned char       y;
  unsigned char       u;
  unsigned char       v;
} gfx_YUV_entry_t;

/* RGB entry */
typedef struct {
  unsigned char       a;
  unsigned char       r;
  unsigned char       g;
  unsigned char       b;
} gfx_RGB_entry_t;

/* Color entry */
typedef union {
  gfx_YUV_entry_t     yuv;
  gfx_RGB_entry_t     rgb;
} gfx_color_entry_t;

/* Bitmap */
typedef struct {
  char                type;
  char                depth;
  short               width;
  short               height;
  short               linelen;
  long                num;
  unsigned  long      *index;
  gfx_color_entry_t   *entry;
  long                size;
  void                *data;
} gfx_bitmap_t;

/* Planar data */
typedef struct {
  void                *ydata;
  void                *cdata[2];
} gfx_bitmap_planar_t;

/* Clip */
typedef struct {
  unsigned short      x;
  unsigned short      y;
  unsigned short      width;
  unsigned short      height;
} gfx_clip_t;

/* Region */
typedef struct {
  unsigned long       mode;
  short               x;
  short               y;
  unsigned short      w;
  unsigned short      h;
} gfx_region_t;

/* Rect */
typedef struct {
  short               pos_x;
  short               pos_y;
  unsigned short      width;
  unsigned short      height;
} gfx_rect_t;

typedef unsigned short gfx_fontset_id_t;        /* font set id type */

typedef struct  _gfx_text_context_t {
  gfx_fontset_id_t    fontset_id;         /* font set id */
  unsigned short      n_color;            /* number of colors */
  unsigned long       *text_color;        /* pointer to color array */
  unsigned short      font_attr;          /* font attribute */
  unsigned long       outline_style;      /* outline style */
  unsigned long       outline_color;      /* outline color */
  unsigned long       outline_sub_color;  /* outline sub color */
  unsigned long       line_color;         /* frame line color */
  unsigned long       font_size;          /* font size */
  unsigned long       font_weight;        /* font weight */
  long                tracking;           /* tracking */
  unsigned long       gl_frame;           /* glyph frame */
} gfx_text_context_t;

typedef union {
  long  val;
  void *pointer;
} gfx_text_item_u;

typedef struct _gfx_text_item {
  unsigned long  string_length;   /* string length[bytes] */
  unsigned long  flag;            /* flag for union below */
  gfx_text_item_u u;
} gfx_text_item_t;

typedef struct _gfx_init_arg_t {
    int               error;
} gfx_init_arg_t;

typedef struct _gfx_term_arg_t {
    int               error;
} gfx_term_arg_t;

typedef struct {
  int cmd;
  int (*handler)(int,unsigned int,void *);
} gfx_command_t;

typedef struct _gfx_get_cvstbl_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
  void              *cvstbl;
} gfx_get_cvstbl_arg_t;

typedef struct _gfx_set_screen_arg_t {
  int               error;
  unsigned long     flag;
} gfx_set_screen_arg_t;

typedef struct _gfx_set_color_palette_head_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
  long              num;
  int               shm_id;
} gfx_set_color_palette_head_arg_t;

typedef struct _gfx_set_color_palette_arg_t {
  gfx_set_color_palette_head_arg_t head;
  unsigned long     buf[GFX_MAX_COLOR_PALETTE<<1];
} gfx_set_color_palette_arg_t;

typedef struct _gfx_convert_color_space_arg_t {
  int               error;
  unsigned long     size;
  unsigned long     mode;
  unsigned long     *address;
} gfx_convert_color_space_arg_t;

typedef struct _gfx_visible_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
} gfx_visible_arg_t;

typedef struct _gfx_invisible_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
} gfx_invisible_arg_t;

typedef struct _gfx_set_region_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
  unsigned short    region_num;
  unsigned short    reserved;
  gfx_region_t      region[4];
} gfx_set_region_arg_t;

typedef struct _gfx_switch_layer_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
  unsigned long     order;
} gfx_switch_layer_arg_t;

typedef struct _gfx_draw_bitmap_head_arg_t {
  int                 error;
  gfx_canvas_id_t     cvs;
  short               cx;
  short               cy;
  gfx_bitmap_t        bmap;
  gfx_bitmap_planar_t planar;
  unsigned char       null_flag;
  unsigned char       reserved;
  unsigned short      clip_x;
  unsigned short      clip_y;
  unsigned short      clip_w;
  unsigned short      clip_h;
  unsigned long       mask_color;
  unsigned short      scale_w;
  unsigned short      scale_h;
} gfx_draw_bitmap_head_arg_t;

typedef struct _gfx_draw_bitmap_arg_t {
  gfx_draw_bitmap_head_arg_t head;
  unsigned long       buf[GFX_MAX_COLOR_PALETTE<<1];
} gfx_draw_bitmap_arg_t;

typedef struct _gfx_bitblt_copy_arg_t {
  int               error;
  gfx_canvas_id_t   dst;
  short             cx;
  short             cy;
  gfx_canvas_id_t   src;
  unsigned short    sx;
  unsigned short    sy;
  unsigned short    sw;
  unsigned short    sh;
} gfx_bitblt_arg_t;


typedef struct _gfx_fill_rect_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
  unsigned long     color;
  short             cx;
  short             cy;
  unsigned short    w;
  unsigned short    h;
} gfx_fill_rect_arg_t;

typedef struct _gfx_draw_line_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
  unsigned long     color;
  unsigned short    line_width;
  short             cx0;
  short             cy0;
  short             cx1;
  short             cy1;
} gfx_draw_line_arg_t;

typedef struct _gfx_get_draw_status_arg_t {
  int               error;
  unsigned long     status;
} gfx_get_draw_status_arg_t;

typedef struct _gfx_store_canvas_arg_t {
  int                 error;
  gfx_canvas_id_t     cvs;
  gfx_bitmap_t        bmap;
  gfx_bitmap_planar_t planar;
  unsigned long       index[GFX_MAX_COLOR_PALETTE];
  gfx_color_entry_t   entry[GFX_MAX_COLOR_PALETTE];
} gfx_store_canvas_arg_t;

typedef struct _gfx_delete_canvas_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
} gfx_delete_canvas_arg_t;

typedef struct _gfx_create_image_buffer_arg_t {
  int               error;
  void              *address;
  unsigned long     size;
} gfx_create_image_buffer_arg_t;

typedef struct _gfx_destroy_image_buffer_arg_t {
  int               error;
  unsigned long     *address;
} gfx_destroy_image_buffer_arg_t;

typedef struct _gfx_set_losd_position_arg_t {
  int               error;
  unsigned short    sx;
  unsigned short    sy;
} gfx_set_losd_position_arg_t;

typedef struct _gfx_set_losd_output_format_arg_t {
  int               error;
  unsigned long     color_format;
} gfx_set_losd_output_format_arg_t;

typedef struct _gfx_get_canvas_information_arg_t {
  int                 error;
  gfx_canvas_id_t     cvs;
  char                depth;
  gfx_bitmap_planar_t fb;
  gfx_rect_t          dim;
  unsigned short      linebytes;
  unsigned long       color_type;
} gfx_get_canvas_information_arg_t;

typedef struct _gfx_txt_string_arg_t {
  int               error;
  gfx_canvas_id_t   cvs;
  gfx_text_context_t tc;
  short             x;
  short             y;
  int               shm_id_1;
  int               shm_id_2;
  int               shm_id_3;
  long              nitem;
  unsigned char     null_flg;
  gfx_rect_t        clip;
} gfx_txt_string_arg_t;

typedef struct _gfx_txt_get_area_arg_t {
  int               error;
  gfx_text_context_t tc;
  int               shm_id_1;
  int               shm_id_2;
  int               shm_id_3;
  long              nitem;
  gfx_rect_t        area;
} gfx_txt_get_area_arg_t;

typedef struct _gfx_set_canvas_format_arg_t {
    int               error;
    gfx_canvas_id_t   cvsid;
    gfx_canvas_id_t   cvs;
    char              format;
} gfx_set_canvas_format_arg_t;

typedef struct _gfx_set_canvas_size_arg_t {
    int               error;
    gfx_canvas_id_t   cvsid;
    gfx_canvas_id_t   cvs;
    unsigned long     flag;
} gfx_set_canvas_size_arg_t;

#endif	/* _GFX_BRIDGE_DATA_H_ */
/* end of gfx_bridge_data.h */
